Imports System.Data


Partial Class ChatArea_ChatRoom
    Inherits System.Web.UI.Page
    Implements System.Web.UI.ICallbackEventHandler

    ''' <summary>
    ''' Ta procedura obsugi zdarzenia preinicjalizacyjnego jest uruchamiana w celu przeprowadzenia inicjalizacji. 
    ''' Pozwala ona okreli motyw i tytu strony, ktre s wydobywane z pliku 
    ''' web.config za porednictwem udostpnionych waciwoci wspuytkowanej klasy Config.
    ''' </summary>
    Protected Sub Page_PreInit(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreInit
        Page.Theme = Config.CurrentTheme
        Page.Title = Config.PageTitle
    End Sub

    ''' <summary>
    ''' Funkcja GetCallbackResult pozostaje pusta, 
    ''' jako miejsce na warto zwracan do metody wywoujcej,
    ''' ale w tym przypadku funkcja nie jest uywana, bo jej
    ''' dziaanie polega przede wszystkim na zwracaniu acuchw tekstowych
    ''' </summary>
    Public Function GetCallbackResult() As String Implements System.Web.UI.ICallbackEventHandler.GetCallbackResult
        Return ""
    End Function

    ''' <summary>
    ''' procedura obsugi zdarzenia RaiseCallbackEvent przechwytuje tre 
    ''' wiadomoci z okna... 
    ''' </summary>
    Public Sub RaiseCallbackEvent(ByVal eventArgument As String) _
        Implements System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent

        If eventArgument.Length > 0 Then
            ChatRoom.SaveMessage(Request.QueryString("chatRoomID"), _
                eventArgument, Session("Email"))
        End If
    End Sub

    ''' <summary>
    ''' Zdarzenie Page_Load umoliwi osadzenie niezbdnego skryptu wywoania zwrotnego 
    ''' w skrypcie JavaScript wykonywanym przez przegldark 
    ''' </summary>
    Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim cm As ClientScriptManager = Page.ClientScript
        Dim cbReference As String
        cbReference = cm.GetCallbackEventReference(Me, "arg", _
            "ReceiveServerData", "")
        Dim callbackScript As String = ""
        callbackScript &= "function CallServer(arg, context)" & _
            "{" & cbReference & "; }"
        cm.RegisterClientScriptBlock(Me.GetType(), "CallServer", _
            callbackScript, True)
        'Pozyskaj obiekt klasy ChatRoom przekazujc do metody 'get' 
        'parametr w postaci idetyfikatora pokoju
        Dim mChatRoom As ChatRoom = ChatRoom.Get( _
            Request.QueryString("ChatRoomId"))
        'ustaw dla etykiety napis bdcy nazw pokoju rozmw
        Label1.Text = mChatRoom.Name
    End Sub


End Class
